# Dynamische Ordner

Verträge durchlaufen in ihrem Lebenszyklus verschiedene Zustände und Status. Ziel der Vertragsüberwachung ist es, diese im Überblick zu behalten und einen schnellen Zugriff zu gewährleisten. 

Dynamische Ordner helfen bei dieser Aufgabe und geben unterschiedliche Sichten auf Verträge. Hierzu werden im Standard Suchen für Verträge nach deren <span
style='font-weight:bold;font-style:italic'>Beziehung</span>, <span
style='font-weight:bold;font-style:italic'>Fristen</span>, <span
style='font-weight:bold;font-style:italic'>Risikoeinstufung</span>, <span
style='font-weight:bold;font-style:italic'>Status</span> sowie deren <span
style='font-weight:bold;font-style:italic'>Zustand</span> ausgeliefert.

{@img img1.png}

## Dynamische Ordner als Archivansicht

Wird ein dynamischer Ordner als<span
style='font-weight:bold;font-style:italic'> Archivansicht gespeichert</span>, kann die Anzahl der enthaltenen Einträge im Client angezeigt werden.

Die Archivansicht kann über die Kacheleinstellungen (ELO 10) konfiguriert werden. In den Optionen kann u. a. definiert werden, Archivansichten an die <span
style='font-weight:bold;font-style:italic'>Navigationsleiste anzuheften </span>sowie die <span
style='font-weight:bold;font-style:italic'>Anzahl der Einträge einer Ansicht</span> anzublenden.

{@img img3.png}

## Eigene Ordner erstellen

Eigene Sichten können über die Funktion<span
style='font-weight:bold;font-style:italic'> Dynamischer Ordner erzeugen</span> der Suche im ELO Java Client erstellt werden. 

<span class="tag_warning">Bei der Erstellung sollte darauf geachtet werden Verträge über den Objekttyp (Maskenfeld <span
style='font-weight:bold;font-style:italic'>SOL_TYPE = CONTRACT</span>) zu identifizieren. Bei Mehrsprachigen Umgebungen sollte zudem darauf geachtet werden, Status nach deren Präfix zu identifizieren. (S* anstelle von S - Abgeschlossen)</span>

<span class="tag_important">Relative Datumsbereichssuchen (ausgehend vom heutigen Tag) bspw. Verträge der letzten 30 Tage, können erst ab ELO Version 10.1 über die Suche erstellt werden. Der ELO Indexserver unterstützt dies aber schon ab Version 9.3.</span>

<span
style='font-weight:bold'>Erstellen von relativen Datumsbereichen vor ELO 10.1</span>

Für ELO 9.3 und ELO 10 können relative Datumsbereiche manuell angelegt werden. Hierzu muss eine Maskensuche erstellt werden, welche alle benötigten Kriterien enthält. Nachdem diese als dynamischer Ordner gespeichert wurde, enthält der Zusatztext eine JSON-Definition der Suche für den Indexserver.

Informationen über den Aufbau der Datumssuchen finden sich in der Versionsgeschichte und JavaDoc des Indexservers. Geändert werden muss hier das data-Objekt der ObjKeys.

    "data":["+0000-00-00...+0000-00-30"]

Der gesamte Inhalt des Zusatztextes (hier für <span
style='font-weight:bold;font-style:italic'>auslaufende Verträge der kommenden 30 Tage</span>) zeigt sich anschließend wie folgt.

    !=JSON10{"findByIndex":{"delDateIso":"","kind":"","maskId":"","exactName":false,"acl":"","pathId":"","objKeys":[
    {"data":["CONTRACT"],"name":"SOL_TYPE","objId":0,"id":0,"clazz":"de.elo.ix.client.ObjKey"},
    {"data":["+0000-00-30...+0000-00-00"],"name":"NEXT_POSSIBLE_TERMINATION","objId":0,"id":0,"clazz":"de.elo.ix.client.ObjKey"}, 
    {"data":["CONTRACT"],"name":"SOL_TYPE","objId":0,"id":0,"clazz":"de.elo.ix.client.ObjKey"},
    {"data":["S*"],"name":"CONTRACT_STATUS","objId":0,"id":0,"clazz":"de.elo.ix.client.ObjKey"}],
    "ownerId":"","xDateIso":"","iDateIso":"","name":"","clazz":"de.elo.ix.client.FindByIndex","desc":""},"clazz":"de.elo.ix.client.FindInfo","findOptions":{"searchLifetimeSeconds":0,"escapeChar":"","evalCount":false,"searchMode":{"_bs":[0,0,0,0],"clazz":"de.elo.ix.client.SearchModeZ"},"wildcards":"","orderBy":"","onlyDeleted":false,"lockZ":{"_bs":[0,0,0,0],"clazz":"de.elo.ix.client.LockZ"},"totalCount":0,"TStamp":"","searchId":"","rangeDelimiter":"...","reserved":"0","sortOrder":1005,"excludeSummary":true,"timeoutSeconds":0,"clazz":"de.elo.ix.client.FindOptions","inclDeleted":false}}
    
    
    

